﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Services;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business; 

/// <summary>
/// Sequence of SP calls to process Referral Auto Triage
/// </summary>
[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
[System.Web.Script.Services.ScriptService]
public class ReferralAutoTriage : System.Web.Services.WebService
{

    public ReferralAutoTriage()
    {

        //Uncomment the following line if using designed components 
        //InitializeComponent(); 
    }

    [WebMethod]
    public int RunTriageReferrals()
    {
        ReferralManager manager = new ReferralManager();
        return manager.AutoTriageAcceptedReferrals(); 
    }

    [WebMethod]
    public int RunTriageDuplicates()
    {
        ReferralManager manager = new ReferralManager();
        return manager.AutoTriageDuplicates();
    }

    [WebMethod]
    public int RunTriageIneligibles()
    {
        ReferralManager manager = new ReferralManager();
        return manager.AutoTriageIneligibles();
    }
    
    [WebMethod]
    public int ReferralsAutoTriageCount()
    {
        ReferralManager manager = new ReferralManager();
        return manager.AutoTriageReferralCount();
    }

}

